; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below.
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10

;-| AI |------------------------------------------------------
[Command]
name = "CPU1" 
command = U, D, F, U, D, F 
time = 0
 
[Command]
name = "CPU2"
command = U, B, F, U, D, F
time = 0
 
[Command]
name = "CPU3"
command = U, D, D, U, D, F
time = 0
 
[Command]
name = "CPU4"
command = U, F, U, B, U, D, F
time = 0
 
[Command]
name = "CPU5"
command = B, B, B, U, B, U, D, F
time = 0
 
[Command]
name = "CPU6"
command = U, D, B, U, B, U, D, F
time = 0
 
[Command]
name = "CPU7"
command = F, F, B, U, B, U, D, F
time = 0
 
[Command]
name = "CPU8"
command = U, D, U, U, B, U, D, F
time = 0
 
[Command]
name = "CPU9"
command = F, B, B, U, B, U, D, F
time = 0
 
[Command]
name = "CPU10"
command = F, F, B, B, U, B, U, D, F
time = 0
[Command]
name = "CPU11"
command = F, F, U,U, U, B, U, D, F
time = 0

[Command]
name = "CPU12"
command = F, F, D,U, U, D, U, D, D
time = 0
[Command]
name = "CPU13"
command = F, F, F,U, U, B, U, D, F
time = 0
[Command]
name = "CPU14"
command = F, F, U,D, F, D, U, D, F
time = 0
[Command]
name = "CPU15"
command = F, F, U,U, U, U, U, U, U
time = 0
[Command]
name = "CPU16"
command = F, F, U,D, U, B, U, D
time = 0
[Command]
name = "CPU17"
command = F, F, U, U, B, U, D, F
time = 0
[Command]
name = "CPU18"
command = F, F, D,B, B, B, U, D, F
time = 0
[Command]
name = "CPU19"
command = F, F, D,D, D, B, U, D, F
time = 0
[Command]
name = "CPU20"
command = F, F, U,F, U, B
time = 0
[Command]
name = "CPU21"
command = U, U, U,U, U, F, U, D, U
time = 0

[Command]
name = "AI22"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI23"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI24"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI25"
command = F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F
time = 0
[Command]
name = "AI26"
command = D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D
time = 0
[Command]
name = "AI27"
command = B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 0
[Command]
name = "AI28"
command = U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U
time = 0
[Command]
name = "AI29"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 0
[Command]
name = "AI30"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c
time = 0
[Command]
name = "AI31"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI32"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 0
[Command]
name = "AI33"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI34"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s
time = 0
[Command]
name = "AI35"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI36"
command = z,z,z,z,z,z,a,a,a,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI37"
command = z,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,z,z,z
time = 0
[Command]
name = "AI38"
command = z,z,z,z,z,a,a,a,z,z,z,z,z,a,a,a,z,z,z
time = 0
[Command]
name = "AI39"
command = z,z,z,z,z,a,a,a,z,z,z,z,z,z,a,a,z,z,z
time = 0
[Command]
name = "AI40"
command = z,z,z,z,a,a,a,z,z,z,z,a,z,z,a,a,z,z,z
time = 0
[Command]
name = "AI41"
command = z,z,z,a,z,z,z,z,z,z,z,z,z,a,a,z,z,z,z
time = 0
[Command]
name = "AI42"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI43"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,a,a,z
time = 0
[Command]
name = "AI44"
command = z,z,a,a,a,a,z,z,z,z,z,z,z,z,z,a,a,a,z
time = 0
[Command]
name = "AI45"
command = z,z,z,z,z,z,a,a,z,z,z,z,z,a,a,a,a,z,z
time = 0
[Command]
name = "AI46"
command = z,z,z,z,z,z,z,z,a,a,a,a,a,a,z,z,z,z,z
time = 0
[Command]
name = "AI47"
command = z,z,z,a,a,a,a,z,z,z,z,z,z,z,z,z,z,z,z
time = 0
[Command]
name = "AI48"
command = z,z,z,z,z,a,a,a,z,z,z,a,a,a,z,z,a,z,a
time = 0
[Command]
name = "AI49"
command = z,z,z,z,a,a,a,z,z,z,z,z,a,a,a,z,z,z,z
time = 0
[Command]
name = "AI50"
command = z,z,z,a,a,z,z,z,z,z,z,z,z,z,a,a,z,z,z
time = 0
[Command]
name = "AI51"
command = b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,x
time = 0
[Command]
name = "AI52"
command = c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,x
time = 0
[Command]
name = "AI53"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 0
[Command]
name = "AI54"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,x
time = 0
[Command]
name = "AI55"
command = z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,z,x
time = 0
[Command]
name = "AI56"
command = s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,s,x
time = 0
[Command]
name = "AI57"
command = F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,x
time = 0
[Command]
name = "AI58"
command = D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,D,x
time = 0
[Command]
name = "AI59"
command = B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,x
time = 0
[Command]
name = "AI60"
command = U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,U,x
time = 0


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;
[Command]
name = "TripleKFPalm"
command = ~D, DF, F, D, DF, F, x
time = 20

[Command]
name = "TripleKFPalm"   ;Same name as above
command = ~D, DF, F, D, DF, F, y
time = 20

[Command]
name = "SmashKFUpper"
command = ~D, DB, B, D, DB, B, x;~F, D, DF, F, D, DF, x
time = 20

[Command]
name = "SmashKFUpper"   ;Same name as above
command = ~D, DB, B, D, DB, B, y;~F, D, DF, F, D, DF, y
time = 20

;-| Special Motions |------------------------------------------------------
[Command]
name = "blocking"
command = $F,x
time = 3

[Command]
name = "blocking" ;Same name as above (buttons in opposite order)
command = x,$F
time = 3

[Command]
name = "upper_x"
command = ~F, D, DF, x

[Command]
name = "upper_y"
command = ~F, D, DF, y

[Command]
name = "upper_xy"
command = ~F, D, DF, x+y

[Command]
name = "QCF_x"
command = ~D, DF, F, x

[Command]
name = "QCF_yz"
command = ~D, DF, F, y+z
[Command]
name = "QCF_xy"
command = ~D, DF, F, x+y
[Command]
name = "QCB_yz"
command = ~D, DB, B, y+z


[Command]
name = "BCF_x"
command = ~B ,DF, F, x
time = 50

[Command]
name = "QCF_y"
command = ~D, DF, F, y

[Command]
name = "QCF_xy"
command = ~D, DF, F, x+y

[Command]
name = "QCB_x"
command = ~D, DB, B, x

[Command]
name = "QCB_y"
command = ~D, DB, B, y


[Command]
name = "QCB_b"
command = ~D, DB, B, b


[Command]
name = "QCB_xy"
command = ~D, DB, B, x+y

[Command]
name = "QCF_a"
command = ~D, DF, F, a

[Command]
name = "QCF_b"
command = ~D, DF, F, b

[Command]
name = "QCF_c"
command = ~D, DF, F, c

[Command]
name = "QCF_ab"
command = ~D, DF, F, a+b

[Command]
name = "FF_ab"
command = F, F, a+b

[Command]
name = "FF_a"
command = F, F, a

[Command]
name = "FF_b"
command = F, F, b

[Command]
name = "xyx"
command = x, y, x


;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------
; AI switch -> ON
[State -1, Activate AI]
type = Varset
triggerall = var(59) != 1
trigger1 = command = "CPU1"
trigger2 = command = "CPU2"
trigger3 = command = "CPU3"
trigger4 = command = "CPU4"
trigger5 = command = "CPU5"
trigger6 = command = "CPU6"
trigger7 = command = "CPU7"
trigger8 = command = "CPU8"
trigger9 = command = "CPU9"
trigger10 = command = "CPU10"
trigger11 = command = "CPU11"
trigger12 = command = "CPU12"
trigger13 = command = "CPU13"
trigger14 = command = "CPU14"
trigger15 = command = "CPU15"
trigger16 = command = "CPU16"
trigger17 = command = "CPU17"
trigger18 = command = "CPU18"
trigger19 = command = "CPU19"
trigger20 = command = "CPU20"
trigger23 = Command = "AI22"
trigger24 = Command = "AI23"
trigger25 = Command = "AI24"
trigger26 = Command = "AI25"
trigger27 = Command = "AI26"
trigger28 = Command = "AI27"
trigger29 = Command = "AI28"
trigger30 = Command = "AI29"
trigger31 = Command = "AI30"
trigger32 = Command = "AI31"
trigger33 = Command = "AI32"
trigger34 = Command = "AI33"
trigger35 = Command = "AI34"
trigger36 = Command = "AI35"
trigger37 = Command = "AI36"
trigger38 = Command = "AI37"
trigger39 = Command = "AI38"
trigger40 = Command = "AI39"
trigger41 = Command = "AI40"
trigger42 = Command = "AI41"
trigger43 = Command = "AI42"
trigger44 = Command = "AI43"
trigger45 = Command = "AI44"
trigger46 = Command = "AI45"
trigger47 = Command = "AI46"
trigger48 = Command = "AI47"
trigger49 = Command = "AI48"
trigger50 = Command = "AI49"
trigger51 = Command = "AI50"
trigger52 = Command = "AI51"
trigger53 = Command = "AI52"
trigger54 = Command = "AI53"
trigger55 = Command = "AI54"
trigger56 = Command = "AI55"
trigger57 = Command = "AI56"
trigger58 = Command = "AI57"
trigger59 = Command = "AI58"
trigger60 = Command = "AI59"
trigger61 = Command = "AI60"
v = 59
value = 1


;Smash Kung Fu Upper (uses one super bar)
[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1300
triggerall = command = "SmashKFUpper"
triggerall = power >= 500
triggerall = statetype != A
trigger1 = ctrl
trigger1 = numhelper(1301) = 0
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3050,3100)
trigger2 = movecontact
trigger3 = stateno = 1310 || stateno = 1330 ;From blocking

;---------------------------------------------------------------------------
;Smash Kung Fu Upper (uses one super bar)
[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1500
triggerall = command = "QCB_yz"
triggerall = power >= powermax
triggerall = statetype != A
trigger1 = ctrl
trigger1 = var(1) = 1

;---------------------------------------------------------------------------
;Smash Kung Fu Upper (uses one super bar)
[State -1, Smash Kung Fu Upper]
type = ChangeState
value = 1600
triggerall = command = "QCF_xy"
triggerall = power >= 1000
triggerall = statetype != A
trigger1 = ctrl
trigger1 = numhelper(1601) < 1
trigger1 = var(1) = 1


;---------------------------------------------------------------------------
;Triple Kung Fu Palm (uses one super bar)
[State -1, Triple Kung Fu Palm]
type = ChangeState
value = 1300
triggerall = command = "TripleKFPalm"
triggerall = power >= 500
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = numhelper(1301) = 0
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3000,3050)
trigger2 = movecontact
trigger3 = stateno = 1310 || stateno = 1330 ;From blocking


;===========================================================================
;This is not a move, but it sets up var(1) to be 1 if conditions are right
;for a combo into a special move (used below).
;Since a lot of special moves rely on the same conditions, this reduces
;redundant logic.
[State -1, Combo condition Reset]
type = VarSet
trigger1 = 1
var(1) = 0

[State -1, Combo condition Check]
type = VarSet
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = stateno != 440 ;Except for sweep kick
trigger2 = movecontact
trigger3 = stateno = 1310 || stateno = 1330 ;From blocking
var(1) = 1

;---------------------------------------------------------------------------
;Fast Kung Fu Knee (1/3 super bar)
[State -1, Fast Kung Fu Knee]
type = ChangeState
value = 1070
triggerall = command = "QCF_c"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Birthday
[State -1, Birthday]
type = ChangeState
value = 1050
triggerall = command = "QCF_a"
trigger1 = var(15) != 1
trigger1 = var(1) ;Use combo condition (above)


;---------------------------------------------------------------------------
;Fast Kung Fu Palm (1/3 super bar)
[State -1, Fast Kung Fu Palm]
type = ChangeState
value = 1055
triggerall = command = "QCF_yz"
triggerall = power >= 330
trigger1 = var(1) ;Use combo condition (above)
trigger1 = numhelper(1056) = 0
trigger1 = statetype != A
;---------------------------------------------------------------------------
;Pizza Wheel
[State -1, Pizza Wheel]
type = ChangeState
value = 1000
triggerall = command = "BCF_x"
trigger1 = var(1) ;Use combo condition (above)
trigger1 = Numhelper(1001) < 2

;---------------------------------------------------------------------------
;Pizza Wheel
[State -1, Pizza Wheel]
type = ChangeState
value = 1002
triggerall = command = "QCF_x"
trigger1 = var(1) ;Use combo condition (above)
trigger1 = Numhelper(1001) < 2
;---------------------------------------------------------------------------
;Strong Kung Fu Palm
[State -1, Strong Kung Fu Palm]
type = ChangeState
value = 1010
triggerall = command = "QCF_y"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Fast Kung Fu Upper (1/3 super bar)
[State -1, Fast Kung Fu Upper]
type = ChangeState
value = 1120
triggerall = command = "QCB_y"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Light Kung Fu Upper
[State -1, Light Kung Fu Upper]
type = ChangeState
value = 1100
triggerall = command = "QCF_b"
trigger1 = var(1) ;Use combo condition (above)



;---------------------------------------------------------------------------
;Light Kung Fu Blow
[State -1, Light Kung Fu Blow]
type = ChangeState
value = 1200
triggerall = command = "QCB_x"
trigger1 = numhelper(1201) = 0
trigger1 = var(1) ;Use combo condition (above)




;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = statetype != A

;---------------------------------------------------------------------------
;Run Fwd Air
[State -1, Run Fwd]
type = ChangeState
value = 101
trigger1 = command = "FF"
trigger1 = statetype = A
trigger1 = ctrl


;---------------------------------------------------------------------------
;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = statetype != A
;---------------------------------------------------------------------------
;Run Back Air
[State -1, Run Back]
type = ChangeState
value = 106
trigger1 = command = "BB"
trigger1 = statetype = A
trigger1 = ctrl



;===========================================================================
;---------------------------------------------------------------------------
;Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = statetype != A

;---------------------------------------------------------------------------
;Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = statetype != A

;---------------------------------------------------------------------------
;Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = stateno != 230
trigger1 = statetype != A


;---------------------------------------------------------------------------
;Standing Strong Kick
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger1 = statetype != A

;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 196
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Strong Punch
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Kick
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Strong Kick
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Strong Kick
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking

[State -1, AI] ; punch
type = ChangeState
value = 200 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = random < 500
triggerall = p2statetype != L 
triggerall = p2bodydist x < 50
triggerall = p2statetype != A 
trigger1 = ctrl = 1 
trigger1 = statetype != A

[State -1, AI] ; punch
type = ChangeState
value = 1100 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = random < 500
triggerall = p2statetype != L 
triggerall = p2statetype = S
trigger1 = ctrl = 1 

[State -1, AI] ; punch
type = ChangeState
value = 1010 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = random < 500
triggerall = p2bodydist x > 70
triggerall = p2statetype != L 
trigger1 = ctrl = 1 

[State -1, AI] ; punch
type = ChangeState
value = 1120 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = random < 500
triggerall = p2statetype != L 
triggerall = p2bodydist x < 80
triggerall = p2statetype != A 
trigger1 = ctrl = 1 

[State -1, AI] ; punch
type = ChangeState
value = 1000 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = random < 100
triggerall = p2statetype != L  
trigger1 = ctrl = 1 
trigger1 = numhelper(1001) < 3

[State -1, AI] ; punch
type = ChangeState
value = 1002 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = random < 100
triggerall = p2statetype != L  
trigger1 = ctrl = 1 
trigger1 = numhelper(1001) < 3

[State -1, AI] ; punch
type = ChangeState
value = 105 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = ctrl = 1
trigger1 = enemy, stateno = 130
trigger2 = enemy, stateno = 131
trigger3 = enemy, stateno = 132 
[State -1, AI] ; punch
type = ChangeState
value = 1300 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = random < 500
triggerall = power >= 500
trigger1 = ctrl = 1 
trigger1 = numhelper(1301) < 1


[State -1, AI] ; punch
type = ChangeState
value = 1200 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = random < 500
triggerall = p2bodydist x > 100
triggerall = p2statetype != L  
trigger1 = ctrl = 1 
trigger1 = numhelper(1201) = 0

[State -1, AI] ; punch
type = ChangeState
value = 1200 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = random < 500
triggerall = p2bodydist y > -50
triggerall = p2statetype != L  
trigger1 = ctrl = 1 
trigger1 = numhelper(1201) = 0


[State -1, AI] ; punch
type = ChangeState
value = 230 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = random < 500
triggerall = p2statetype != L 
triggerall = p2bodydist x < 50
trigger1 = ctrl = 1 
trigger1 = inguarddist
trigger2 = ctrl = 1  
trigger2 = p2statetype = A
trigger2 = p2dist y < -90
trigger1 = statetype != A
[State -1, AI] ; punch
type = ChangeState
value = 240 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = random < 500
triggerall = p2statetype != L 
triggerall = p2bodydist x < 60
triggerall = p2statetype != A 
trigger1 = ctrl = 1 
trigger1 = statetype != A

[State -1, AI] ; punch
type = ChangeState
value = 210 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = random < 500
triggerall = p2statetype != L 
triggerall = p2bodydist x < 60
triggerall = p2statetype != A 
trigger1 = ctrl = 1 
trigger1 = statetype != A
[State -1, AI] ; punch
type = ChangeState
value = 210 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = stateno != 200
triggerall = random < 500
triggerall = p2statetype != L 
triggerall = p2bodydist x < 60
triggerall = p2statetype != A 
trigger1 = prevstateno = 200


[State -1, AI] ; punch
type = ChangeState
value = 1600 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
triggerall = random < 5
trigger1 = power >= 1000
trigger1 = numhelper(1601) < 1
;trigger1 = enemy, vel x > 2
;trigger1 = enemy, vel x < -2
[State -1, AI] ; punch
type = ChangeState
value = 1500 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = statetype != A
trigger1 = power = powermax
trigger1 = p2bodydist x > 100

[State -1, AI] ; punch
type = ChangeState
value = 1070 
triggerall = command = "QCF_c"
triggerall = roundstate = 2 
trigger1 = movetype = H
trigger1 = statetype != L

[State -1, AI] ; punch
type = ChangeState
value = 1070 
triggerall = roundstate = 2
triggerall = palno = 12
triggerall = var(59) = 1 
;triggerall = random < 500
trigger1 = movetype = H
trigger1 = statetype != L

[State -1, AI] ; punch
type = ChangeState
value = 1070 
triggerall = roundstate = 2
triggerall = var(59) = 1 
triggerall = random < 30
trigger1 = movetype = H
trigger1 = statetype != L