; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
; 
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
; 

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 30

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1

;-| Super Motions |--------------------------------------------------------

[Command]
name = "thesicklecombo"
command = ~D,DF,F,D,DF,F,a+b
time = 30

[Command]
name = "thesicklecombo"
command = ~D,DF,F,D,DF,F,b+c
time = 30

[Command]
name = "thesicklecombo"
command = ~D,DF,F,D,DF,F,a+c
time = 30

[Command]
name = "mobiusdoublereacharound"
command = ~D,DB,B,D,DB,B,a+b
time = 30

[Command]
name = "mobiusdoublereacharound"
command = ~D,DB,B,D,DB,B,b+c
time = 30

[Command]
name = "mobiusdoublereacharound"
command = ~D,DB,B,D,DB,B,a+c
time = 30

;-| Special Motions |------------------------------------------------------

[Command]
name = "encryption"
command = ~D,DF,F,a

[Command]
name = "encryption"
command = ~D,DF,F,b

[Command]
name = "encryption"
command = ~D,DF,F,c

[Command]
name = "sicklekind1"
command = ~D,DB,B,a

[Command]
name = "sicklekind2"
command = ~D,DB,B,b

[Command]
name = "sicklekind3"
command = ~D,DB,B,c

[Command]
name = "sicklekindex"
command = ~D,DB,B,a+b

[Command]
name = "sicklekindex"
command = ~D,DB,B,b+c

[Command]
name = "sicklekindex"
command = ~D,DB,B,a+c

[Command]
name = "transportalize"
command = ~D,D,a

[Command]
name = "transportalize"
command = ~D,D,b

[Command]
name = "transportalize"
command = ~D,D,c

[Command]
name = "imputtingyouonspeakercrab"
command = ~F,D,DF,a

[Command]
name = "imputtingyouonspeakercrab"
command = ~F,D,DF,b

[Command]
name = "imputtingyouonspeakercrab"
command = ~F,D,DF,c

;-| WICKITY WACKITY AI!!! |------------------------------------------------------
[Command]
name = "CPU1"
command = U, D, F, U, D, F
time = 0

[Command]
name = "CPU2"
command = U, B, F, U, D, F
time = 0

[Command]
name = "CPU3"
command = U, D, D, U, D, F
time = 0

[Command]
name = "CPU4"
command = U, F, U, B, U, D, F
time = 0

[Command]
name = "CPU5"
command = B, B, B, U, B, U, D, F
time = 0

[Command]
name = "CPU6"
command = U, D, B, U, B, U, D, F
time = 0

[Command]
name = "CPU7"
command = F, F, B, U, B, U, D, F
time = 0

[Command]
name = "CPU8"
command = U, D, U, U, B, U, D, F
time = 0

[Command]
name = "CPU9"
command = F, B, B, U, B, U, D, F
time = 0

[Command]
name = "CPU10"
command = F, F, B, B, U, B, U, D, F
time = 0

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /$B,x
time = 1

[Command]
name = "back_y"
command = /$B,y
time = 1

[Command]
name = "back_z"
command = /$B,z
time = 1

[Command]
name = "down_x"
command = /$D,x
time = 1

[Command]
name = "down_y"
command = /$D,y
time = 1

[Command]
name = "down_z"
command = /$D,z
time = 1

[Command]
name = "fwd_x"
command = /$F,x
time = 1

[Command]
name = "fwd_y"
command = /$F,y
time = 1

[Command]
name = "fwd_z"
command = /$F,z
time = 1

[Command]
name = "up_x"
command = /$U,x
time = 1

[Command]
name = "up_y"
command = /$U,y
time = 1

[Command]
name = "up_z"
command = /$U,z
time = 1

[Command]
name = "back_a"
command = /$B,a
time = 1

[Command]
name = "back_b"
command = /$B,b
time = 1

[Command]
name = "back_c"
command = /$B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_a"
command = /$F,a
time = 1

[Command]
name = "fwd_b"
command = /$F,b
time = 1

[Command]
name = "fwd_c"
command = /$F,c
time = 1

[Command]
name = "up_a"
command = /$U,a
time = 1

[Command]
name = "up_b"
command = /$U,b
time = 1

[Command]
name = "up_c"
command = /$U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd" ;Required (do not remove)
command = $F
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;This is not a move, but it sets up var(1) to be 1 if conditions are right
;for a combo into a special move (used below).
;Since a lot of special moves rely on the same conditions, this reduces
;redundant logic.

;===========================================================================
;-|-AI-|--------------------------------------------------------------------
[State -1, Activate AI]
type = Varset
triggerall = var(59) != 1
trigger1 = command = "CPU1"
trigger2 = command = "CPU2"
trigger3 = command = "CPU3"
trigger4 = command = "CPU4"
trigger5 = command = "CPU5"
trigger6 = command = "CPU6"
trigger7 = command = "CPU7"
trigger8 = command = "CPU8"
trigger9 = command = "CPU9"
trigger10 = command = "CPU10"
v = 59
value = 1

;---------------------------------------------------------------------------
[State -1, AI Attack];The Sickle
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<5 && p2dist y = [-50,20]
triggerall = random%5=0
trigger2 = (stateno = 200) && movecontact
value = 200

[State -1, AI Attack];Clawsickle
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<5 && p2dist y = [-50,20]
triggerall = random%5=0
trigger2 = (stateno = 210) && movecontact
value = 210

[State -1, AI Attack];Strong Kick
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<5 && p2dist y = [-50,20]
triggerall = random%5=0
trigger2 = (stateno = 220) && (Movecontact)
value = 220

[State -1, AI Attack];Encryption
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<20 && p2dist y = [-50,20]
triggerall = random%5=0
triggerall = NumHelper(1001) != 2
value = 1000

[State -1, AI Attack];Sicklekind 1
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<25 && p2dist y = [-50,20]
triggerall = random%5=0
value = 1100

[State -1, AI Attack];Sicklekind 2
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<25 && p2dist y = [-50,20]
triggerall = random%5=0
value = 1101

[State -1, AI Attack];Sicklekind 3
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<25 && p2dist y = [-50,20]
triggerall = random%5=0
value = 1102

[State -1, AI Attack];Sicklekind EX
type = Changestate
triggerall = AILevel && enemy,statetype != L&&power >= 300
trigger1 = ctrl && statetype != A&&p2bodydist x<30 && p2dist y = [-50,20]
triggerall = random%5=0
value = 1110

[State -1, AI Attack];Transportalize
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<60 && p2dist y = [-50,20]
triggerall = random%5=0
value = 1200

[State -1, AI Attack];I'M PUTTING YOU ON SPEAKER CRAB
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<20 && p2dist y = [-50,20]
triggerall = random%5=0
triggerall = NumHelper(1301) = 0
value = 1300

[State -1, AI Attack];The Sickle Combo
type = Changestate
triggerall = AILevel && enemy,statetype != L&&power >= 1000
trigger1 = ctrl && statetype != A&&p2dist y = [-50,20]
triggerall = random%5=0
value = 3000

[State -1, AI Attack];Mobius Double Reacharound
type = Changestate
triggerall = AILevel && enemy,statetype != L&&power >= 3000
trigger1 = ctrl && statetype != A&&p2dist y = [-50,20]
triggerall = random%5=0
triggerall = NumHelper(3101) = 0
value = 3100

[State -1, AI Attack]
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<30 && p2dist y = [-50,20]
triggerall = random%5=0
trigger2 = stateno = 220 && ctrl
value = 10

[State -1, AI Attack]
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<30 && p2dist y = [-50,20]
triggerall = random%5=0
trigger2 = stateno = 220 && ctrl
value = 10

[State -1, AI Attack]
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<30 && p2dist y = [-50,20]
triggerall = random%5=0
trigger2 = stateno = 10 && ctrl
value = 11

[State -1, AI Attack]
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<5 && p2dist y = [-50,20]
triggerall = random%5=0
trigger2 = stateno = 11 && ctrl
trigger2 = (stateno = 410) && (Movecontact)
value = 410

[State -1, AI Attack]
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<5 && p2dist y = [-50,20]
triggerall = random%5=0
trigger2 = stateno = 11 && ctrl
trigger2 = (stateno = 410) && (Movecontact)
value = 410

[State -1, AI Attack]
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<5 && p2dist y = [-50,20]
triggerall = random%5=0
trigger2 = stateno = 11 && ctrl
trigger2 = (stateno = 420) && (Movecontact)
trigger3 = (stateno = 220) && (Movecontact)
value = 420

[State -1, AI Attack]
type = Changestate
triggerall = AILevel && enemy,statetype != L
trigger1 = ctrl && statetype != A&&p2bodydist x<5 && p2dist y = [-50,20]
triggerall = random%5=0
trigger2 = stateno = 410 && ctrl
trigger2 = (stateno = 420) && (Movecontact)
trigger3 = (stateno = 220) && (Movecontact)
value = 420

;===========================================================================
;---------------------------------------------------------------------------
; The Sickle Combo
[State -1, The Sickle Combo]
type = ChangeState
value = 3000
triggerall = command = "thesicklecombo"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3000,3050)
trigger2 = (stateno = 200) && (movecontact) && time > 2
trigger3 = (stateno = 210) && (movecontact) && time > 2
trigger4 = (stateno = 220) && (movecontact) && time > 2
trigger5 = (stateno = 400) && (movecontact) && time > 2
trigger6 = (stateno = 410) && (movecontact) && time > 2
trigger7 = (stateno = 420) && (movecontact) && time > 2

;---------------------------------------------------------------------------
; Mobius Double Reacharound
[State -1, Mobius Double Reacharound]
type = ChangeState
value = 3100
triggerall = NumHelper(3101) = 0
triggerall = command = "mobiusdoublereacharound"
triggerall = power >= 3000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3000,3050)
trigger2 = (stateno = 200) && (movecontact) && time > 2
trigger3 = (stateno = 210) && (movecontact) && time > 2
trigger4 = (stateno = 220) && (movecontact) && time > 2
trigger5 = (stateno = 400) && (movecontact) && time > 2
trigger6 = (stateno = 410) && (movecontact) && time > 2
trigger7 = (stateno = 420) && (movecontact) && time > 2

;---------------------------------------------------------------------------
;Encryption
[State -1, Encryption]
type = ChangeState
value = 1000
triggerall = NumHelper(1001) != 2
triggerall = command != "holddown"
triggerall = command = "encryption"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && (movecontact) && time > 2
trigger3 = (stateno = 210) && (movecontact) && time > 2
trigger4 = (stateno = 220) && (movecontact) && time > 2

;---------------------------------------------------------------------------
;Sicklekind EX
[State -1, Sicklekind EX]
type = ChangeState
value = 1110
triggerall = power >= 300
triggerall = command != "holddown"
triggerall = command = "sicklekindex"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && (movecontact) && time > 2
trigger3 = (stateno = 210) && (movecontact) && time > 2
trigger4 = (stateno = 220) && (movecontact) && time > 2

;---------------------------------------------------------------------------
;Sicklekind 1
[State -1, Sicklekind 1]
type = ChangeState
value = 1100
triggerall = command != "holddown"
triggerall = command = "sicklekind1"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && (movecontact) && time > 2
trigger3 = (stateno = 210) && (movecontact) && time > 2
trigger4 = (stateno = 220) && (movecontact) && time > 2

;---------------------------------------------------------------------------
;Sicklekind 2
[State -1, Sicklekind 2]
type = ChangeState
value = 1101
triggerall = command != "holddown"
triggerall = command = "sicklekind2"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && (movecontact) && time > 2
trigger3 = (stateno = 210) && (movecontact) && time > 2
trigger4 = (stateno = 220) && (movecontact) && time > 2

;---------------------------------------------------------------------------
;Sicklekind 3
[State -1, Sicklekind 3]
type = ChangeState
value = 1102
triggerall = command != "holddown"
triggerall = command = "sicklekind3"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && (movecontact) && time > 2
trigger3 = (stateno = 210) && (movecontact) && time > 2
trigger4 = (stateno = 220) && (movecontact) && time > 2

;---------------------------------------------------------------------------
;Transportalize
[State -1, Transportalize]
type = ChangeState
value = 1200
triggerall = command != "holddown"
triggerall = command = "transportalize"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;I'M PUTTING YOU ON SPEAKER CRAB
[State -1, I'M PUTTING YOU ON SPEAKER CRAB]
type = ChangeState
value = 1300
triggerall = NumHelper(1301) = 0
triggerall = command != "holddown"
triggerall = command = "imputtingyouonspeakercrab"
trigger1 = statetype = S
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
; Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Throw
[State -1, Throw]
type = ChangeState
value = 800
triggerall = command = "c"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 10
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 10
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H

;===========================================================================
;---------------------------------------------------------------------------
; Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "s"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
; Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && movecontact && time > 2
trigger3 = (stateno = 210) && movecontact && time > 2
trigger4 = (stateno = 220) && movecontact && time > 2
trigger5 = (stateno = 400) && movecontact && time > 2
trigger6 = (stateno = 410) && movecontact && time > 2
trigger7 = (stateno = 420) && movecontact && time > 2

;---------------------------------------------------------------------------
; Stand Medium Punch
[State -1, Stand Medium Punch]
type = ChangeState
value = 210
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && movecontact && time > 2
trigger3 = (stateno = 210) && movecontact && time > 2
trigger4 = (stateno = 220) && movecontact && time > 2
trigger5 = (stateno = 400) && movecontact && time > 2
trigger6 = (stateno = 410) && movecontact && time > 2
trigger7 = (stateno = 420) && movecontact && time > 2

;---------------------------------------------------------------------------
; Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 220
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && movecontact && time > 2
trigger3 = (stateno = 210) && movecontact && time > 2
trigger4 = (stateno = 220) && movecontact && time > 2
trigger5 = (stateno = 400) && movecontact && time > 2
trigger6 = (stateno = 410) && movecontact && time > 2
trigger7 = (stateno = 420) && movecontact && time > 2

;---------------------------------------------------------------------------
; Crouching Light Punch
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 200) && movecontact && time > 2
trigger3 = (stateno = 210) && movecontact && time > 2
trigger4 = (stateno = 220) && movecontact && time > 2
trigger5 = (stateno = 400) && movecontact && time > 2
trigger6 = (stateno = 410) && movecontact && time > 2
trigger7 = (stateno = 420) && movecontact && time > 2

;---------------------------------------------------------------------------
; Crouching Medium Punch
[State -1, Crouching Medium Punch]
type = ChangeState
value = 410
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 200) && movecontact && time > 2
trigger3 = (stateno = 210) && movecontact && time > 2
trigger4 = (stateno = 220) && movecontact && time > 2
trigger5 = (stateno = 400) && movecontact && time > 2
trigger6 = (stateno = 410) && movecontact && time > 2
trigger7 = (stateno = 420) && movecontact && time > 2

;---------------------------------------------------------------------------
; Crouching Strong Punch
[State -1, Crouching Strong Punch]
type = ChangeState
value = 420
triggerall = command = "c"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 200) && movecontact && time > 2
trigger3 = (stateno = 210) && movecontact && time > 2
trigger4 = (stateno = 220) && movecontact && time > 2
trigger5 = (stateno = 400) && movecontact && time > 2
trigger6 = (stateno = 410) && movecontact && time > 2
trigger7 = (stateno = 420) && movecontact && time > 2

;---------------------------------------------------------------------------
; Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = (stateno = 600) && movecontact && time > 2
trigger3 = (stateno = 610) && movecontact && time > 2
trigger4 = (stateno = 620) && movecontact && time > 2

;---------------------------------------------------------------------------
; Jump Medium Punch
[State -1, Jump Medium Punch]
type = ChangeState
value = 610
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = (stateno = 600) && movecontact && time > 2
trigger3 = (stateno = 610) && movecontact && time > 2
trigger4 = (stateno = 620) && movecontact && time > 2

;---------------------------------------------------------------------------
; Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 620
triggerall = command = "c"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = (stateno = 600) && movecontact && time > 2
trigger3 = (stateno = 610) && movecontact && time > 2
trigger4 = (stateno = 620) && movecontact && time > 2

;---------------------------------------------------------------------------
