; Karkat Vantas's state file.
; There are comments scattered through this file, so you may like to
; take a look if would like to learn more about the cns.

;---------------------------------------------------------------------------
; Format:
; [Statedef STATENO]
; type = ?      S/C/A/L  stand/crouch/air/liedown
; movetype = ?  I/A/H    idle/attack/gethit
; physics = ?   S/C/A/N  stand/crouch/air/none
; juggle = ?             air juggle points move requires
;
; [State STATENO, ?]     ? - any number you choose
; type = ?
; ...

;---------------------------------------------------------------------------
; Lose by Time Over
; CNS difficulty: basic
[Statedef 170]
type = S
ctrl = 0
anim = 170
velset = 0,0

[State 170, 1]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

;---------------------------------------------------------------------------
; Win state decider
; CNS difficulty: basic
[Statedef 180]
type = S

[State 180, WinQuoteSet]
type = VictoryQuote
trigger1 = 1
value = 1+(random%12)

[State 180, WinQuoteSet]
type = VictoryQuote
triggerall = numenemy
trigger1 = enemy,Name = "John Egbert"
value = 13

[State 180, WinQuoteSet]
type = VictoryQuote
triggerall = numenemy
trigger1 = enemy,Name = "Homestar Runner"
trigger2 = enemy,Name = "Homestar"
value = 14

[State 180, WinQuoteSet]
type = VictoryQuote
triggerall = numenemy
trigger1 = enemy,Name = "Thomas Ridgewell"
value = 15

[State 180, WinQuoteSet]
type = VictoryQuote
triggerall = numenemy
trigger1 = enemy,Name = "Viola" && enemy,authorname = "AwesomeBlue"
value = 16

[State 180, WinQuoteSet]
type = VictoryQuote
triggerall = numenemy
trigger1 = enemy,Name = "Tord Larsson"
value = 17

[State 180, WinQuoteSet]
type = VictoryQuote
triggerall = numenemy
trigger1 = enemy,Name = "Jeff 'Psycho Dad' Ridgeway Sr."
value = 18

[State 180, WinQuoteSet]
type = VictoryQuote
triggerall = numenemy
trigger1 = enemy,Name = "Karkat Vantas" && enemy,authorname = "Hamon240"
value = 19

[State 180, 1]
type = VarRandom
trigger1 = Time = 0
v = 1
range = 0,200

[State 180, 2]
type = ChangeState
trigger1 = Var(1) = [0,100]
value = 181

[State 180, 3]
type = ChangeState
trigger1 = Var(1) = [10,200]
value = 182


;---------------------------------------------------------------------------
; Win pose 1
; CNS difficulty: basic
[Statedef 181]
type = S
ctrl = 0
anim = 180
velset = 0,0

[State 181, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 1,1

[State 181, Assert]
type = AssertSpecial
trigger1 = Time <= 400
flag = RoundNotOver

[State 181, 1]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

;---------------------------------------------------------------------------
; Win pose 2
; CNS difficulty: basic
[Statedef 182]
type = S
ctrl = 0
anim = 181
velset = 0,0

[State 182, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 1,0

[State 182, Assert]
type = AssertSpecial
trigger1 = Time <= 400
flag = RoundNotOver

[State 182, 1]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

;---------------------------------------------------------------------------
; Introduction
; CNS difficulty: basic
[Statedef 190]
type = S
ctrl = 0
anim = 190
velset = 0,0

[State 190, Explod]
type = Explod
trigger1 = time = 0
anim = 191
ID = 191
pos = 0,0
postype = p1
ownpal = 1
scale = 0.3,0.3
removetime = -2

[State 190, Explod]
type = Explod
trigger1 = AnimElem = 2
anim = 192
ID = 192
pos = 0,0
postype = p1
ownpal = 1
scale = 0.6,0.6
removetime = -2
sprpriority = 4

[State 190, Sound]
type = PlaySnd
trigger1 = AnimElem = 2
value = 190,0

[State 190, 1] ;Freeze animation until PreIntro is over
type = ChangeAnim
trigger1 = RoundState = 0
value = 190

[State 190, 2] ;Assert this until you want "round 1, fight" to begin
type = AssertSpecial
trigger1 = 1
flag = Intro

[State 190, 4] ;Change to stand state
type = ChangeState
trigger1 = AnimTime = 0
value = 0

;---------------------------------------------------------------------------
; Taunt
; CNS difficulty: easy
[Statedef 195]
type = S
ctrl = 0
anim = 195
velset = 0,0
movetype = I
physics = S
sprpriority = 2

[State 195, 2]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Standing Light Punch
; CNS difficulty: easy
[Statedef 200]
type    = S				;State-type: S-stand, C-crouch, A-air, L-liedown
movetype= A				;Move-type: A-attack, I-idle, H-gethit
physics = S				;Physics: S-stand, C-crouch, A-air
juggle  = 1				;Number of air juggle points move takes
;Commonly-used controllers:
velset = 0,0			;Set velocity (x,y) (Def: no change)
ctrl = 0				;Set ctrl (Def: no change)
anim = 200				;Change animation (Def: no change)
poweradd = 20			;Power to add (Def: 0)
sprpriority = 2			;Set layering priority to 2 (in front)

[State 200, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 2,0

[State 200, 1]
type = HitDef
trigger1 = Time = 0
attr = S, NA			;Attribute: Standing, Normal Attack
damage = 12, 0			;Damage that move inflicts, guard damage
animtype = Light			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 3, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 0				;Spark anim no (Def: set above)
sparkxy = -15, -30		;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 0			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 5		;Time that the opponent slides back
ground.hittime  = 12		;Time opponent is in hit state
ground.velocity = -2		;Velocity at which opponent is pushed
airguard.velocity = -1.9,-.8	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -1.4,-3		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 12			;Time before opponent regains control in air

[State 200, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Standing Medium Punch
; CNS difficulty: easy
[Statedef 210]
type    = S
movetype= A
physics = S
juggle  = 4
poweradd= 65
ctrl = 0
velset = 0,0
anim = 210

[State 210, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 2,1

[State 210, 1]
type = HitDef
trigger1 = Time = 0
attr = S, NA			;Attribute: Standing, Normal Attack
damage = 33, 0			;Damage that move inflicts, guard damage
animtype = Medium			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 3, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 1				;Spark anim no (Def: set above)
sparkxy = -15, -30		;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 1			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 5		;Time that the opponent slides back
ground.hittime  = 12		;Time opponent is in hit state
ground.velocity = -2.8		;Velocity at which opponent is pushed
airguard.velocity = -1.9,-.8	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -1.4,-3		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 12			;Time before opponent regains control in air

[State 210, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Standing Strong Punch
; CNS difficulty: easy
[Statedef 220]
type    = S
movetype= A
physics = S
juggle  = 4
poweradd= 65
ctrl = 0
velset = 0,0
anim = 220

[State 220, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 2,2

[State 220, 1]
type = HitDef
trigger1 = Time = 0
attr = S, NA			;Attribute: Standing, Normal Attack
damage = 60, 0			;Damage that move inflicts, guard damage
animtype = Hard			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 3, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 2				;Spark anim no (Def: set above)
sparkxy = -5, -10	;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 2			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 5		;Time that the opponent slides back
ground.hittime  = 12		;Time opponent is in hit state
ground.velocity = -3.1		;Velocity at which opponent is pushed
airguard.velocity = -1.9,-.8	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -1.4,-3		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 12			;Time before opponent regains control in air

[State 220, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Crouching Light Punch
; CNS difficulty: easy
; Description: Simple crouching attack. The HitDef's guardflag parameter
;     is set to "L", meaning that the move can only be guarded low
;     (crouching), and not by standing or jumping opponents.
;     Like for all light attacks, it's a good idea to keep the slidetime
;     and hittime parameters at a smaller number, so the opponent isn't
;     stunned for too long. For all crouching attacks you have to
;     remember to set the attr parameter to indicate that it is crouching
;     attack. In this case, "C, NA" stands for "crouching, normal attack".
;     The HitDef's priority is set at 3, instead of the default of 4,
;     so this attack has a lower priority than most others, meaning the
;     player will get hit instead of trading hits with the opponent if
;     their attack collision boxes (Clsn1) intersect each other's Clsn2
;     boxes at the same time.
[Statedef 400]
type    = C
movetype= A
physics = C
juggle  = 5
poweradd= 15
ctrl = 0
anim = 400

[State 400, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 2,0

[State 400, 1]
type = HitDef
trigger1 = Time = 0
attr = C, NA			;Attribute: Standing, Normal Attack
damage = 12, 0			;Damage that move inflicts, guard damage
animtype = Light			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = L			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 3, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 0				;Spark anim no (Def: set above)
sparkxy = -15, -30  	;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 0			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 5		;Time that the opponent slides back
ground.hittime  = 12		;Time opponent is in hit state
ground.velocity = -2		;Velocity at which opponent is pushed
airguard.velocity = -1.9,-.8	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -6,-6		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 12			;Time before opponent regains control in air

[State 400, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 11
ctrl = 1

;---------------------------------------------------------------------------
; Crouching Medium Punch
[Statedef 410]
type    = C
movetype= A
physics = C
juggle  = 6
poweradd= 50
ctrl = 0
anim = 410

[State 410, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 2,1

[State 410, 1]
type = HitDef
trigger1 = Time = 0
attr = C, NA			;Attribute: Standing, Normal Attack
damage = 33, 0			;Damage that move inflicts, guard damage
animtype = Medium			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = LA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 3, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 1				;Spark anim no (Def: set above)
sparkxy = -15, -30		;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 1			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = Low		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 6		;Time that the opponent slides back
ground.hittime  = 9		;Time opponent is in hit state
ground.velocity = -2.8		;Velocity at which opponent is pushed
airguard.velocity = -1.9,-.8	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = Low			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -1.4,-3		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 12			;Time before opponent regains control in air

[State 410, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 11
ctrl = 1

;---------------------------------------------------------------------------
; Crouching Strong Punch
[Statedef 420]
type    = C
movetype= A
physics = C
juggle  = 6
poweradd= 50
ctrl = 0
anim = 420

[State 420, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 2,2

[State 420, 1]
type = HitDef
trigger1 = Time = 0
attr = C, NA			;Attribute: Standing, Normal Attack
damage = 60, 0			;Damage that move inflicts, guard damage
animtype = Hard			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = L			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 3, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 2				;Spark anim no (Def: set above)
sparkxy = -5, -10	;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 2			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 5		;Time that the opponent slides back
ground.hittime  = 12		;Time opponent is in hit state
ground.velocity = -3.1		;Velocity at which opponent is pushed
airguard.velocity = -1.9,-.8	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -1.4,-3		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 12			;Time before opponent regains control in air

[State 420, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 11
ctrl = 1

;---------------------------------------------------------------------------
; Jump Light Punch
; CNS difficulty: easy
[Statedef 600]
type    = A
movetype= A
physics = A
juggle  = 2
poweradd= 11
ctrl = 0
anim = 600

[State 600, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 2,0

[State 600, 1]
type = HitDef
trigger1 = Time = 0
attr = A, NA			;Attribute: Standing, Normal Attack
damage = 12, 0			;Damage that move inflicts, guard damage
animtype = Light			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 3, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 0				;Spark anim no (Def: set above)
sparkxy = -15, -30	;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 0			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 5		;Time that the opponent slides back
ground.hittime  = 12		;Time opponent is in hit state
ground.velocity = -2		;Velocity at which opponent is pushed
airguard.velocity = -1.9,-.8	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -1.4,-3		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 12			;Time before opponent regains control in air

[State 600, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 50
ctrl = 1

;---------------------------------------------------------------------------
; Jump Medium Punch
; CNS difficulty: easy
[Statedef 610]
type    = A
movetype= A
physics = A
juggle  = 4
poweradd= 65
ctrl = 0
anim = 610

[State 610, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 2,1

[State 610, 1]
type = HitDef
trigger1 = Time = 0
attr = A, NA			;Attribute: Standing, Normal Attack
damage = 33, 0			;Damage that move inflicts, guard damage
animtype = Medium			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 4, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 1				;Spark anim no (Def: set above)
sparkxy = -15, -30		;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 1			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 10		;Time that the opponent slides back
ground.hittime  = 10		;Time opponent is in hit state
ground.velocity = -2.8		;Velocity at which opponent is pushed
airguard.velocity = -1,-.8	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -2,-4.2		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 12			;Time before opponent regains control in air

[State 610, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 50
ctrl = 1

;---------------------------------------------------------------------------
; Jump Strong Punch
; CNS difficulty: easy
[Statedef 620]
type    = A
movetype= A
physics = A
juggle  = 4
poweradd= 70
ctrl = 0
anim = 620

[State 620, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 2,2

[State 620, 1]
type = HitDef
trigger1 = Time = 0
attr = A, NA			;Attribute: Standing, Normal Attack
damage = 60, 0			;Damage that move inflicts, guard damage
animtype = Hard			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 3, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 2				;Spark anim no (Def: set above)
sparkxy = -5, -10		;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 2			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 5		;Time that the opponent slides back
ground.hittime  = 12		;Time opponent is in hit state
ground.velocity = -3.1		;Velocity at which opponent is pushed
airguard.velocity = -1.9,-.8	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -1.4,-3		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 12			;Time before opponent regains control in air

[State 620, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 50
ctrl = 1

;---------------------------------------------------------------------------
; Throw - Attempt
; CNS difficulty: medium-advanced
; Description: Throws are not difficult to make, although then can be
;     tedious at times. Throw attempt states have a HitDef of a
;     special format. The key parameters in a throw are p1stateno
;     and p2stateno. If the HitDef successfully connects, then
;     the attacker will change to the state number specified by
;     p1stateno, and the opponent will be change to the state
;     number assigned to p2stateno. The special thing about p2stateno
;     is that the opponent will be temporarily brought into the
;     attacker's state file. In this case, no matter who the
;     opponent is, he will be taken to state 820 of this file (kfm.cns)
;     and remain here until the end of the throw (look at his debug
;     information when he is being thrown; the text changes to yellow
;     to mean that he is in another player's state file).
[Statedef 800]
type    = S
movetype= A
physics = S
juggle  = 0
velset = 0,0
ctrl = 0
anim = 800

; Notes: The '-' symbol in the hitflag field means that it only affects
;   players who are not in a hit state. This prevents the player from combo-ing
;   into the throw. The priority should be set to a low number, such as
;   1 or 2, so that the throw does not take precedence over normal attacks.
;   The type of priority must always be set to "Miss" or "Dodge" for throws,
;   otherwise strange behavior can result.
[State 800, 1]
type = HitDef
Trigger1 = Time = 0
attr = S, NT          ;Attributes: Standing, Normal Throw
hitflag = M-          ;Affect only ground people who are not being hit
priority = 1, Miss    ;Throw has low priority, must be miss or dodge type.
sparkno = -1          ;No spark
sprpriority = 1       ;Draw in front of p2
p1facing = ifelse (command = "holdfwd", -1, 1) ;Turn if holding forwards
p2facing = 1          ;Force p2 to face player
p1stateno = 810       ;On success, player changes to state 810
p2stateno = 820       ;If hit, p2 changes to state 820 in player's cns
fall = 1              ;Force p2 into falling down

[State 800, 2]
type = ChangeState
Trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Throwing the opponent
; Description: In this state, the player throws the opponent by binding him to
;     various offsets based on his current frame of animation. For
;     example, [State 810, Bind 1] binds the opponent to an offset of
;     28 pixels in front of the player. That puts him around where the hand
;     is at. Is is important to keep the opponent bound using a
;     TargetBind controller at all times, until you let him go. This
;     is especially important if your player has a Clsn2 box that
;     allows him to get hit while throwing someone. Each time a player
;     gets hit, all his bound targets will be set to a fall state. If
;     the opponent is not bound, then he might get stuck in his thrown
;     state when his attacker is knocked out of the throw halfway.
; Notes: There is a TargetLifeAdd controller to decrease the opponent's
;     life, and a TargetState controller to change his state to a
;     falling state when KFM lets go of him.
[Statedef 810]
type    = S
movetype= A
physics = N
anim = 810
poweradd = 60

[State 810, Grab Sound]
type = PlaySnd
trigger1 = Time = 0
value = 800, 0

[State 810, Bind]
type = TargetBind
trigger1 = Time = 0
pos = -23, 0

[State 810, Bind]
type = TargetBind
trigger1 = AnimElem = 2
pos = -10, -35

[State 810, Bind]
type = TargetBind
trigger1 = AnimElem = 3
pos = 10, -35

[State 810, Swing Sound]
type = PlaySnd
trigger1 = AnimElem = 4
value = 800, 1

[State 810, Hurt 11]
type = TargetLifeAdd
trigger1 = AnimElem = 4
value = -60

[State 810, Throw 11]
type = TargetState
trigger1 = AnimElem = 4
value = 821

[State 810, State End]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Opponent Thrown
; (a custom gethit state)
; Description: This is the state that the opponent changes to after being
;     hit by the throw HitDef. The important thing here is to use a
;     ChangeAnim2 controller. The difference between ChangeAnim2 and
;     ChangeAnim is that ChangeAnim2 changes the player's animation to
;     an action in the AIR file of the attacker (in this case, kfm.air),
;     whereas ChangeAnim always changes the player to an action in his
;     own AIR file. Look at Action 820 in kfm.air for some extra
;     comments.
[Statedef 820]
type    = A
movetype= H
physics = N
velset = 0,0

[State 820, Bind]
type = SprPriority 
trigger1 = AnimElem = 2
value = 3

[State 820, 1]
type = ChangeAnim2
Trigger1 = Time = 0
value = 820

;---------------------------------------------------------------------------
; Opponent thrown into the air
; (a custom gethit state)
; Description: This state has the opponent flying through the air and
;     falling down onto the ground. The SelfState controller sets the
;     opponent back using to his own state file when he his the ground.
;     Controllers 821,2 and 821,3 allow the opponent to recover by
;     hitting his recovery command when he is falling.
[Statedef 821]
type    = A
movetype= H
physics = N
velset = -3.5,-8
poweradd = 40

[State 821, 1] ;Gravity
type = VelAdd
Trigger1 = 1
y = .4

[State 821, 2] ; Recover near ground (use ChangeState)
type = ChangeState
triggerall = Vel Y > 0
triggerall = Pos Y >= -20
triggerall = alive
triggerall = CanRecover
trigger1 = Command = "recovery"
value = 5200 ;HITFALL_RECOVER

[State 821, 3] ; Recover in mid air (use SelfState)
type = SelfState
triggerall = Vel Y > 0
triggerall = alive
triggerall = CanRecover
trigger1 = Command = "recovery"
value = 5210 ;HITFALL_AIRRECOVER

[State 821, 4] ;Hit ground
type = SelfState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 5100 ;Hit ground

;---------------------------------------------------------------------------
; Encryption
[Statedef 1000]
type    = S
movetype= A
physics = S
juggle  = 4
poweradd= 25
ctrl = 0
velset = 0,0
anim = 0

[State 1000, Helper]
type = Helper
trigger1 = time = 0
helpertype = normal
name = "Encryption File"
ID = 1001
stateno = 1001
pos = 0,-130
postype = p2
keyctrl = 0
ownpal = 1

[State 1000, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Encryption
[Statedef 1001]
type    = S
movetype= A
physics = S
juggle  = 4
ctrl = 0
velset = 0,0
anim = 1000

[State 1001, Sound]
type = PlaySnd
trigger1 = animelem = 3
value = 1000,0

[State 1001, VelAdd]
type = VelAdd
trigger1 = animelem = 4
y = 12

[State 1001, 1]
type = HitDef
trigger1 = Time = 0
attr = S, NA			;Attribute: Standing, Normal Attack
damage = 25, 2			;Damage that move inflicts, guard damage
animtype = Light			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 3, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 0				;Spark anim no (Def: set above)
sparkxy = -15, -8		;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 0			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 5		;Time that the opponent slides back
ground.hittime  = 12		;Time opponent is in hit state
ground.velocity = 3		;Velocity at which opponent is pushed
airguard.velocity = 2.1,-.9	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = 1.5,-4		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 12			;Time before opponent regains control in air

[State 1001, 5]
type = ChangeState
trigger1 = Pos Y >= 0
trigger1 = Vel Y >= 0
value = 1002

;---------------------------------------------------------------------------
[Statedef 1002]
type    = S
movetype= A
physics = S
juggle  = 4
ctrl = 0
velset = 0,0
anim = 1001

[State 1002, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 1000,1

[State 1002, VelSet]
type = VelSet
trigger1 = Time = 0
Y = 0

[State 1002, PosSet]
type = PosSet
trigger1 = Time = 0
Y = 0

[State 1002, 5]
type = DestroySelf
trigger1 = animtime = 0

;---------------------------------------------------------------------------
; Sicklekind 1
[Statedef 1100]
type    = S
movetype= A
physics = S
juggle  = 4
poweradd= 15
ctrl = 0
velset = 0,0
anim = 1100

[State 1100, Sound]
type = PlaySnd
trigger1 = animelem = 2
value = 2,0

[State 1100, 4]
type = Projectile
projanim = 1101
velocity = 7,0
projscale = 0.3,0.3
trigger1 = animelem = 2
attr = S, NA			;Attribute: Standing, Normal Attack
damage = 12, 3			;Damage that move inflicts, guard damage
animtype = Light			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
offset  = 26,-20
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 0				;Spark anim no (Def: set above)
sparkxy = 30, -8		;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 0			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 15		;Time that the opponent slides back
ground.hittime  = 15		;Time opponent is in hit state
ground.velocity = -2		;Velocity at which opponent is pushed
airguard.velocity = -1.4,-2.3	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -2,-2		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 15			;Time before opponent regains control in air

[State 1100, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Sicklekind 2
[Statedef 1101]
type    = S
movetype= A
physics = S
juggle  = 4
poweradd= 40
ctrl = 0
velset = 0,0
anim = 1102

[State 1101, Sound]
type = PlaySnd
trigger1 = animelem = 2
value = 2,2

[State 1101, 4]
type = Projectile
projanim = 1103
velocity = 4,0
projscale = 0.3,0.3
trigger1 = animelem = 2
attr = S, NA			;Attribute: Standing, Normal Attack
damage = 50, 11			;Damage that move inflicts, guard damage
animtype = Hard			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
offset  = 26,-20
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 2				;Spark anim no (Def: set above)
sparkxy = 50, -8		;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 2			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 15		;Time that the opponent slides back
ground.hittime  = 15		;Time opponent is in hit state
ground.velocity = -5,-3		;Velocity at which opponent is pushed
airguard.velocity = -2.3,-2.9	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -5,-3		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 15			;Time before opponent regains control in air

[State 1101, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Sicklekind 3
[Statedef 1102]
type    = S
movetype= A
physics = S
juggle  = 4
poweradd= 25
ctrl = 0
velset = 0,0
anim = 1104

[State 1102, Sound]
type = PlaySnd
trigger1 = animelem = 2
value = 2,1

[State 1102, 4]
type = Projectile
projanim = 1105
velocity = 8,0
projscale = 0.3,0.3
trigger1 = animelem = 2
attr = S, NA			;Attribute: Standing, Normal Attack
damage = 42, 9			;Damage that move inflicts, guard damage
animtype = Medium			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
offset  = 26,-20
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 1				;Spark anim no (Def: set above)
sparkxy = 30, -8		;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 1			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 15		;Time that the opponent slides back
ground.hittime  = 15		;Time opponent is in hit state
ground.velocity = -4		;Velocity at which opponent is pushed
airguard.velocity = -2.8,-3.5	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -4,-3		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 15			;Time before opponent regains control in air

[State 1102, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Sicklekind EX
[Statedef 1110]
type    = S
movetype= A
physics = S
juggle  = 4
poweradd= -300
ctrl = 0
velset = 0,0
anim = 1110

[State 1110, Afterimage]
type = AfterImage
trigger1 = Time = 0
length = 13
PalBright   =  30, 30,  0
PalContrast =  70, 70, 20
PalAdd      = -10,-10,-10
PalMul      = .85,.85,.50
TimeGap  = 1
FrameGap = 2
Trans = Add
time = 2

[State 1110, Blink Yellow]
type = PalFX
trigger1 = Time = 0
time = 8
add = 32,16,0
sinadd = 64,32,5,3

[State 1110, PlaySnd]
type = PlaySnd
trigger1 = time = 0
value = S1999,0

[State 1110, Sound]
type = PlaySnd
trigger1 = animelem = 2
value = 2,2

[State 1110, 4]
type = Projectile
projanim = 1111
velocity = 15,0
projscale = 0.3,0.3
trigger1 = animelem = 2
attr = S, NA			;Attribute: Standing, Normal Attack
damage = 70, 20			;Damage that move inflicts, guard damage
animtype = Heavy			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
offset  = 26,-20
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 3				;Spark anim no (Def: set above)
sparkxy = 50, -8		;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 2			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 15		;Time that the opponent slides back
ground.hittime  = 15		;Time opponent is in hit state
ground.velocity = -6,-6		;Velocity at which opponent is pushed
airguard.velocity = -4.4,-4.4	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -6,-6		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 15			;Time before opponent regains control in air
fall = 1
air.fall = 1

[State 1110, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Transportalize
[Statedef 1200]
type    = S				
movetype= A			
physics = S			
juggle  = 1				
velset = 0,0			
ctrl = 0				
anim = 1200						

[State 1200, PlaySnd]
type = PlaySnd
trigger1 = time = 0
trigger2 = AnimElem = 3
value = 190,0

[State 1200, Explod]
type = Explod
trigger1 = time = 0
trigger2 = AnimElem = 3
anim = 1201
ID = 1201
pos = 0,0
postype = p1
ownpal = 1
scale = 0.3,0.3
removetime = -2

[State 1200, Explod]
type = Explod
trigger1 = time = 0
trigger2 = AnimElem = 3
anim = 192
ID = 192
pos = 0,0
postype = p1
ownpal = 1
scale = 0.6,0.6
removetime = -2
sprpriority = 4

[State 1200, VelAdd]
type = VelAdd
trigger1 = AnimElem = 2
x = 40	

[State 1200, Turn]
type = Turn
trigger1 = AnimElem = 3

[State 1200, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; I'M PUTTING YOU ON SPEAKER CRAB
[Statedef 1300]
type    = S				
movetype= A			
physics = S			
juggle  = 1				
velset = 0,0
poweradd = 55			
ctrl = 0				
anim = 1300

[State 1300, Helper]
type = Helper
trigger1 = AnimElem = 2
helpertype = normal
name = "Speaker Crab"
ID = 1301
stateno = 1301
pos = 25,0
postype = p1
keyctrl = 0
ownpal = 1						

[State 1300, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Speaker Crab
[Statedef 1301]
type    = S
movetype= A
physics = S
juggle  = 4
ctrl = 0
velset = 0,0
anim = 1301
sprpriority = 4

[State 1301, VelAdd]
type = VelAdd
trigger1 = 1
x = 2

[State 1301, 1]
type = HitDef
trigger1 = Time = 0
attr = S, NA			;Attribute: Standing, Normal Attack
damage = 15, 1			;Damage that move inflicts, guard damage
animtype = Light			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 3, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 0				;Spark anim no (Def: set above)
sparkxy = -15, 0		;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 0			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 5		;Time that the opponent slides back
ground.hittime  = 12		;Time opponent is in hit state
ground.velocity = -2 	;Velocity at which opponent is pushed
airguard.velocity = -1.5,-1.1	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -1.2,-4		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 12			;Time before opponent regains control in air

[State 1301, 5]
type = DestroySelf
trigger1 = time = 100

;---------------------------------------------------------------------------
; The Sickle Combo
[Statedef 3000]
type    = S				
movetype= A			
physics = S			
juggle  = 1				
velset = 0,0			
ctrl = 0				
anim = 3000	

[State 3000, SuperPause]
type = SuperPause
trigger1 = time = 0 ;AnimElem = 2, 1
pos = 0, -22
anim = 100
sound = 20, 0
poweradd = -1000
time = 60

[State 3000, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 1,2

[State 3000, 2]
type = VelSet
trigger1 = AnimElem = 2
trigger2 = AnimElem = 6
trigger3 = AnimElem = 10
trigger4 = AnimElem = 14
trigger5 = AnimElem = 18
trigger6 = AnimElem = 22
trigger7 = AnimElem = 26
trigger8 = AnimElem = 30
trigger9 = AnimElem = 34
trigger10 = AnimElem = 38
trigger11 = AnimElem = 42
x = 6

[State 3000, Sound]
type = PlaySnd
trigger1 = AnimElem = 3
trigger2 = AnimElem = 7
trigger3 = AnimElem = 11
trigger4 = AnimElem = 15
trigger5 = AnimElem = 19
trigger6 = AnimElem = 23
trigger7 = AnimElem = 27
trigger8 = AnimElem = 31
trigger9 = AnimElem = 35
trigger10 = AnimElem = 39
trigger11 = AnimElem = 43
value = 2,2

[State 3000, 1]
type = HitDef
trigger1 = AnimElem = 3
trigger2 = AnimElem = 7
trigger3 = AnimElem = 11
trigger4 = AnimElem = 15
trigger5 = AnimElem = 19
trigger6 = AnimElem = 23
trigger7 = AnimElem = 27
trigger8 = AnimElem = 31
trigger9 = AnimElem = 35
trigger10 = AnimElem = 39
attr = S, NA			;Attribute: Standing, Normal Attack
damage = 12, 2			;Damage that move inflicts, guard damage
animtype = Hard			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 3, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 3, 50			;Time attacker pauses, time opponent shakes
sparkno = 2				;Spark anim no (Def: set above)
sparkxy = -15, -30	;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 2			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 5		;Time that the opponent slides back
ground.hittime  = 12		;Time opponent is in hit state
ground.velocity = -3.1		;Velocity at which opponent is pushed
airguard.velocity = -1.9,-.8	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -1.4,-3		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 12			;Time before opponent regains control in air
kill = 0
getpower = 0,0
givepower = 0,0	

[State 3000, 1]
type = HitDef
trigger1 = AnimElem = 43
attr = S, NA			;Attribute: Standing, Normal Attack
damage = 85, 15			;Damage that move inflicts, guard damage
animtype = Heavy			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 3, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 3, 3			;Time attacker pauses, time opponent shakes
sparkno = 3				;Spark anim no (Def: set above)
sparkxy = -15, -30	;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
hitsound = S5, 2			;Sound to play on hit
guardsound = S6, 0			;Sound to play on guard
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 5		;Time that the opponent slides back
ground.hittime  = 12		;Time opponent is in hit state
ground.velocity = -6,-12		;Velocity at which opponent is pushed
airguard.velocity = -3.5,-6	;Guard velocity in air (def: (air.xvel*1.5, air.yvel/2))
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -6,-12		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 12			;Time before opponent regains control in air
getpower = 0,0
givepower = 0,0	
fall = 1
air.fall = 1						

[State 3000, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Mobius Double Reacharound
[Statedef 3100]
type    = S				
movetype= A			
physics = S			
juggle  = 1				
velset = 0,0			
ctrl = 0				
anim = 3100	

[State 3100, SuperPause]
type = SuperPause
trigger1 = time = 0 ;AnimElem = 2, 1
pos = 0, -24
anim = 102
sound = 20, 0
poweradd = -3000
time = 250
movetime = 250

[State 3100, Sound]
type = PlaySnd
trigger1 = Time = 0
value = 3100,0

[State 3100, Explod]
type = Explod
trigger1 = time = 0
anim = 3101
ID = 3101
pos = 20,-50
postype = p1
ownpal = 1
removetime = 250
scale = 0.8,0.8
sprpriority = 4
supermovetime = 250

[State 3201, "Oh my god..."]
type = Explod
trigger1 = time = 100
anim = 3103
ID = 3102
postype = back
facing = 1
bindtime = -1
supermovetime = -1
removetime = 150
sprpriority = -4
shadow = 68,68,68
ownpal = 1
removeongethit = -1
ontop = 1
pos = 160,138
scale = 0.45,0.5

[State 3201, "Oh my god..."]
type = Explod
trigger1 = time = 100
anim = 3102
ID = 3102
postype = back
facing = 1
bindtime = -1
supermovetime = -1
removetime = 150
sprpriority = -4
shadow = 68,68,68
ownpal = 1
removeongethit = -1
ontop = 1
pos = 160,138
scale = 0.45,0.5

[State 3100, Helper]
type = Helper
trigger1 = AnimTime = 0
helpertype = normal
name = "Cursor"
ID = 3101
stateno = 3101
pos = 0,-13
postype = p1
keyctrl = 0
ownpal = 1
size.xscale = 0.5
size.yscale = 0.5

[State 3100, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Cursor
[Statedef 3101]
type    = S
movetype= A
physics = S
juggle  = 4
ctrl = 0
velset = 0,0
anim = 3104
sprpriority = 4

[State 3101, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = noshadow

[State 3101, VelAdd]
type = VelAdd
trigger1 = 1
x = 1.2

[State 3101, 1]
type = HitDef
Trigger1 = Time = 0
attr = S, NT       
hitflag = M-
priority = 1, Miss
sparkno = -1
p1facing = ifelse (command = "holdfwd", -1, 1)
p2facing = 1
p1stateno = 3102
p2stateno = 3103
fall = 1

[State 3101, 5]
type = DestroySelf
trigger1 = time = 100

;---------------------------------------------------------------------------
[Statedef 3102]
type    = S
movetype= A
physics = S
juggle  = 4
ctrl = 0
velset = 0,0
anim = 3105

[State 3102, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = noshadow

[State 3102, PosAdd]
type = PosAdd
trigger1 = time = 0
X = (P2Dist X)-0
y = 0

[State 3102, Sound]
type = PlaySnd
trigger1 = animelem = 7
value = 3100,1

[State 3102, Explod]
type = Explod
trigger1 = animelem = 7
anim = 3101
ID = 3101
pos = 15,-90
postype = p2
ownpal = 1
removetime = 120
scale = 0.8,0.8
sprpriority = 4
facing = -1
supermovetime = 120

[State 3102, SuperPause]
type = SuperPause
trigger1 = animelem = 7
pos = 0, -22
anim = -1
time = 280
movetime = 280
darken = 0

[State 3201, Mobius Double Reacharound Virus]
type = Explod
trigger1 = time = 120
anim = 3106
ID = 3102
postype = back
facing = 1
bindtime = -1
supermovetime = -1
removetime = 150
sprpriority = -4
shadow = 68,68,68
ownpal = 1
removeongethit = -1
ontop = 1
pos = 160,138
scale = 0.45,0.5

[State 3201, Helper]
type = Helper
trigger1 = time = 330
helpertype = normal
name = "Explosion"
ID = 3104
stateno = 3104
pos = 0,-30
postype = p2
keyctrl = 0
ownpal = 1
supermovetime = 330

[State 3102, 5]
type = DestroySelf
trigger1 = time = 350

;---------------------------------------------------------------------------
[Statedef 3103]
type    = A
movetype= H
physics = N
velset = 0,0

[State 3103, VelSet]
type = VelSet
trigger1 = Time = 0
Y = 0

[State 3103, PosSet]
type = PosSet
trigger1 = Time = 0
Y = 0

[State 3103, 1]
type = ChangeAnim
Trigger1 = Time = 0
value = 0

[State 3103, 3]
type = NotHitBy
trigger1 = time < 30
value = SCA

;---------------------------------------------------------------------------
; Explosion
[Statedef 3104]
type    = S
movetype= A
physics = S
juggle  = 4
ctrl = 0
velset = 0,0
anim = 3107

[State 3104, AssertSpecial]
type = AssertSpecial
trigger1 = 1
flag = unguardable
flag2 = noshadow
ignorehitpause = 1
persistent = 1

[State 3104, Sound]
type = PlaySnd
trigger1 = time = 0
value = 3100,2

[State 3104, 1]
type = HitDef
trigger1 = time = 0
attr = S, NA			;Attribute: Standing, Normal Attack
damage = 430         		;Damage that move inflicts, guard damage
animtype = Heavy			;Animation type: Light, Medium, Heavy, Back (def: Light)
guardflag = MA			;Flags on how move is to be guarded against
hitflag = MAF			;Flags of conditions that move can hit
priority = 3, Hit			;Attack priority: 0 (least) to 7 (most), 4 default
					;Hit/Miss/Dodge type (Def: Hit)
pausetime = 8, 8			;Time attacker pauses, time opponent shakes
sparkno = 3				;Spark anim no (Def: set above)
sparkxy = -10, -3   	;X-offset for the "hit spark" rel. to p2,
					;Y-offset for the spark rel. to p1
ground.type = High		;Type: High, Low, Trip (def: Normal)
ground.slidetime = 15		;Time that the opponent slides back
ground.hittime  = 15		;Time opponent is in hit state
ground.velocity = -12,-25		;Velocity at which opponent is pushed
air.type = High			;Type: High, Low, Trip (def: same as ground.type)
air.velocity = -12,-25		;X-velocity at which opponent is pushed,
					;Y-velocity at which opponent is pushed
air.hittime = 15			;Time before opponent regains control in air
air.animtype = Back
air.juggle = 8
air.fall = 1
palfx.time = 12
palfx.add = 9,240,128
palfx.mul = 255,70,17
palfx.sinadd = 0,0,0,1
palfx.color = 256
envshake.time = 50
envshake.ampl = 30
fall = 1
air.fall = 1

[State 3104, TargetState]
type = TargetState
trigger1 = movehit
value = 7697
ignorehitpause = 1

[State 3104, 5]
type = DestroySelf
trigger1 = AnimTime = 0

;---------------------------------------------------------------------------
; Override common states (use same number to override) :
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
; States that are always executed (use statedef -2)
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
; States that are executed when in self's state file (use statedef -3)
;---------------------------------------------------------------------------

[Statedef -3]

;This controller plays a sound everytime the player lands from a jump, or
;from a back-dash.
[State -3, Landing Sound]
type = PlaySnd
triggerall = Time = 1
trigger1 = stateno = 52 ;Jump land
trigger2 = stateno = 106 ;Run-back land
value = 40, 0

[State -3, Ow Sound]
type = PlaySnd
trigger1 = StateNo = [5000,5090]
trigger1 = Time = 0
value = 5000, 0+Random%3
channel = 0
