; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   Name= "some_name"
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /F, a    ;hold fwd while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;               command = ~30
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their engine.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;-| Super Motions |------------------------------------------------------

[Command]
Name= "super_golpe_a"
command = ~D, DF, F, D, DF, F, a
time = 20

[Command]
Name= "super_golpe_b"
command = ~D, DF, F, D, DF, F, b
time = 20

[Command]
Name= "super_golpe_c"
command = ~D, DF, F, D, DF, F, c
time = 20

[Command]
Name= "super_misil_x"
command = ~D, DF, F, D, DF, F, x
time = 20

[Command]
Name= "super_misil_y"
command = ~D, DF, F, D, DF, F, y
time = 20

[Command]
Name= "super_misil_z"
command = ~D, DF, F, D, DF, F, z
time = 20

[Command]
Name= "famiglia_misil"
command = ~D, DB, B, D, DB, B, x
time = 20

[Command]
Name= "Falcon_Punch_y"
command = ~D, DB, B, D, DB, B, y
time = 20

[Command]
Name= "Falcon_Punch_z"
command = ~D, DB, B, D, DB, B, z
time = 20

[Command]
Name= "laser_beam"
command = ~D, DB, B, D, DB, B, a
time = 20

[Command]
Name= "chiamare_clone"
command = ~D, DB, B, D, DB, B, b
time = 20

[Command]
Name= "misil_rein"
command = ~D, DB, B, D, DB, B, c
time = 20

[Command]
name = "raging_rice_cake"
command = s
time = 10

;-| Special Motions |------------------------------------------------------

[Command]
Name= "misil_x"
command = ~D, DF, F, x

[Command]
Name= "misil_y"
command = ~D, DF, F, y

[Command]
Name= "misil_z"
command = ~D, DF, F, z

[Command]
Name= "glope_dash"
command = ~D, DF, F, a

[Command]
Name= "genocido_cuttah"
command = ~D, DF, F, b

[Command]
Name= "chuck_assist"
command = ~D, DF, F, c

[Command]
Name= "pico_assist"
command = ~D, DB, B, c

[Command]
Name= "bender_assist"
command = b+c

;-| Double Tap |-----------------------------------------------------------
[Command]
Name= "FF";Required (do not remove)
command = F, F
time = 10

[Command]
Name= "BB";Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
Name= "recovery";Required (do not remove)
command = a+b
time = 1

[Command]
Name= "ab"
command = a+b
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
Name= "fwd_x"
command = /F,x
time = 1

[Command]
Name= "fwd_y"
command = /F,y
time = 1

[Command]
Name= "fwd_z"
command = /F,z
time = 1

[Command]
Name= "fwd_a"
command = /F,a
time = 1

[Command]
Name= "fwd_b"
command = /F,b
time = 1

[Command]
Name= "fwd_c"
command = /F,c
time = 1

[Command]
Name= "downfwd_a"
command = /DF,a
time = 1

[Command]
Name= "downfwd_b"
command = /DF,b
time = 1

[Command]
Name= "back_a"
command = /B,a
time = 1

[Command]
Name= "back_b"
command = /B,b
time = 1

[Command]
Name= "back_c"
command = /B,c
time = 1

[Command]
Name= "down_a"
command = /$D,a
time = 1

[Command]
Name= "down_b"
command = /$D,b
time = 1

[Command]
Name= "down_c"
command = /$D,c
time = 1

[Command]
Name= "fwd_ab"
command = /F, a+b
time = 1

[Command]
Name= "back_ab"
command = /B, a+b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
Name= "a"
command = a
time = 1

[Command]
Name= "b"
command = b
time = 1

[Command]
Name= "c"
command = c
time = 1

[Command]
Name= "x"
command = x
time = 1

[Command]
Name= "y"
command = y
time = 1

[Command]
Name= "z"
command = z
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
Name= "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
Name= "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
Name= "holdup";Required (do not remove)
command = /$U
time = 1

[Command]
Name= "holddown";Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1]                  ;Don't change this
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1=command="command_name"
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;---------------------------------------------------------------------------
;RunBack
[State -1]
type = ChangeState
value = 105
triggerall = Var(59) <= 0
trigger1=command="BB"
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;RunFwd
[State -1]
type = ChangeState
value = 100
triggerall = Var(59) <= 0
trigger1=command="FF"
trigger1 = statetype = S
trigger1 = ctrl = 1

;===========================================================================
; super misil
[State -1]
type = ChangeState
value = 3000
triggerall=command="super_misil_x"
triggerall = Var(59) <= 0
triggerall = power >= 1000 ;Level 1
trigger1 = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1
trigger3 = stateno = 3010
trigger4 = stateno = 3030
trigger5 = stateno = 3060

[State -1]
type = ChangeState
value = 3000
triggerall=command="super_misil_y"
triggerall = Var(59) <= 0
triggerall = power >= 1000 ;Level 1
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1
trigger3 = stateno = 3010
trigger4 = stateno = 3030
trigger5 = stateno = 3060

[State -1]
type = ChangeState
value = 3000
triggerall=command="super_misil_z"
trigger1 = RoundState = 2
triggerall = Var(59) <= 0
triggerall = power >= 1000 ;Level 1
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1
trigger3 = stateno = 3010
trigger4 = stateno = 3030
trigger5 = stateno = 3060

;===========================================================================
; super golpes
[State -1]
type = ChangeState
value = 3010
triggerall=command="super_golpe_a"
triggerall = RoundState = 2
triggerall = Var(59) <= 0
triggerall = power >= 1000 ;Level 1
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1
trigger3 = stateno = 3000
trigger4 = stateno = 3030
trigger5 = stateno = 3060
 

[State -1]
type = ChangeState
value = 3010
triggerall=command="super_golpe_b"
triggerall = Var(59) <= 0
triggerall = power >= 1000 ;Level 1
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1
trigger3 = stateno = 3000
trigger4 = stateno = 3030
trigger5 = stateno = 3060

[State -1]
type = ChangeState
value = 3010
triggerall=command="super_golpe_c"
triggerall = Var(59) <= 0
triggerall = power >= 1000 ;Level 1
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1
trigger3 = stateno = 3000
trigger4 = stateno = 3030
trigger5 = stateno = 3060

;===========================================================================
;famiglia_misil
[State -1]
type = ChangeState
value = 3060
triggerall=command="famiglia_misil"
triggerall = Var(59) <= 0
triggerall = power >= 1000 ;Level 1
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1
trigger3 = stateno = 3000
trigger4 = stateno = 3010
trigger5 = stateno = 3030

;===========================================================================
;falcon_punch
[State -1]
type = ChangeState
value = 3020
triggerall=command="Falcon_Punch_y"
triggerall = Var(59) <= 0
triggerall = power >= 1000 ;Level 1
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1

[State -1]
type = ChangeState
value = 3020
triggerall=command="Falcon_Punch_z"
triggerall = Var(59) <= 0
triggerall = power >= 1000 ;Level 1
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1

;===========================================================================
; laser_beam
[State -1]
type = ChangeState
value = 3030
triggerall=command="laser_beam"
triggerall = Var(59) <= 0
triggerall = power >= 2000 ;Level 2
triggerall = RoundState = 2
trigger1 = ctrl = 1
trigger1 = statetype != A
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1
trigger3 = stateno = 3000
trigger4 = stateno = 3010
trigger5 = stateno = 3060
 

;===========================================================================
; chiamare_clone
[State -1]
type = ChangeState
value = 3040
triggerall=command="chiamare_clone"
triggerall = Var(59) <= 0
triggerall = power >= 2000 ;Level 2
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1

;===========================================================================
; misil_rein
[State -1]
type = ChangeState
value = 3050
triggerall=command="misil_rein"
triggerall = Var(59) <= 0
triggerall = power >= 2000 ;Level 2
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1

;===========================================================================
; Raging Rice Cake
[State -1]
type = ChangeState
value = 3070
triggerall=command="raging_rice_cake"
triggerall = Var(59) <= 0
triggerall = power >= 3000 ;Level 3
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1


;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
; misil
[State -1]
type = ChangeState
value = 1000
triggerall=command="misil_x"
triggerall = Var(59) <= 0
triggerall = numproj = 0
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1

[State -1]
type = ChangeState
value = 1010
triggerall=command="misil_y"
triggerall = Var(59) <= 0
triggerall = numproj = 0
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1

[State -1]
type = ChangeState
value = 1020
triggerall=command="misil_z"
triggerall = Var(59) <= 0
triggerall = numproj = 0
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = [200, 450]
trigger2 = movecontact = 1
Stand_x

;---------------------------------------------------------------------------
; fast_glope

[State -1]
type = ChangeState
value = 2500
triggerall=command="glope_dash"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1

;genocido_cuttah
[State -1]
type = ChangeState
value = 2600
triggerall=command="genocido_cuttah"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1

;Pico_assist
[State -1]
type = ChangeState
value = 4010
triggerall=command="pico_assist"
triggerall = Var(59) <= 0
TriggerAll = Helper(9500), Var(1) = 90
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1

;Chuck_assist
[State -1]
type = ChangeState
value = 4000
triggerall=command="chuck_assist"
triggerall = Var(59) <= 0
TriggerAll = Helper(9500), Var(2) = 90
triggerall = RoundState = 2
trigger1 = statetype != A
trigger1 = ctrl = 1

;Bender_Assist
[State -1]
type = ChangeState
value = 4020
triggerall=command="bender_assist"
triggerall = Var(59) <= 0
TriggerAll = Helper(9500), Var(3) = 90
trigger1 = statetype != A
trigger1 = ctrl = 1


;===========================================================================

[State -1]
type = ChangeState
value = 200
triggerall=command="x"
triggerall=command !="holddown"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = time > 7

;---------------------------------------------------------------------------
;Stand_y
[State -1]
type = ChangeState
value = 210
triggerall=command="y"
triggerall=command !="holddown"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1

;---------------------------------------------------------------------------
;Stand_z
[State -1]
type = ChangeState
value = 220
triggerall=command="z"
triggerall=command !="holddown"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 210
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;Stand_a
[State -1]
type = ChangeState
value = 230
triggerall=command="a"
triggerall=command !="holddown"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 230
trigger2 = time > 7

;---------------------------------------------------------------------------
;Stand_b
[State -1]
type = ChangeState
value = 240
triggerall=command="b"
triggerall=command !="holddown"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 230
trigger2 = movecontact = 1

;---------------------------------------------------------------------------
;Stand_c
[State -1]
type = ChangeState
value = 250
triggerall=command="c"
triggerall=command !="holddown"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 230
trigger2 = movecontact = 1
trigger3 = stateno = 240
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;Crouch_x
[State -1]
type = ChangeState
value = 400
triggerall=command="x"
triggerall=command="holddown"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 400
trigger2 = time > 7

;---------------------------------------------------------------------------
;Crouch_y
[State -1]
type = ChangeState
value = 410
triggerall=command="y"
triggerall=command="holddown"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 400
trigger2 = movecontact = 1

;---------------------------------------------------------------------------
;Crouch_z
[State -1]
type = ChangeState
value = 420
triggerall=command="z"
triggerall=command="holddown"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 400
trigger2 = movecontact = 1
trigger3 = stateno = 410
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;Crouch_a
[State -1]
type = ChangeState
value = 430
triggerall=command="a"
triggerall=command="holddown"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 430
trigger2 = time > 7

;---------------------------------------------------------------------------
;Crouch_b
[State -1]
type = ChangeState
value = 440
triggerall=command="b"
triggerall=command="holddown"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 430
trigger2 = movecontact = 1

;---------------------------------------------------------------------------
;Crouch_c
[State -1]
type = ChangeState
value = 450
triggerall=command="c"
triggerall=command="holddown"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 430
trigger2 = movecontact = 1
trigger3 = stateno = 440
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;Jump_x
[State -1]
type = ChangeState
value = 600
trigger1=command="x"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = A
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Jump_y
[State -1]
type = ChangeState
value = 610
trigger1=command="y"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Jump_z
[State -1]
type = ChangeState
value = 620
trigger1=command="z"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Jump_a
[State -1]
type = ChangeState
value = 630
trigger1=command="a"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Jump_b
[State -1]
type = ChangeState
value = 640
trigger1=command="b"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Jump_c
[State -1]
type = ChangeState
value = 650
trigger1=command="c"
triggerall = Var(59) <= 0
triggerall = RoundState = 2
trigger1 = statetype = A
trigger1 = ctrl = 1
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;AI

;---------------------------------------------------------------------------
;===========================================================================

[State -1, AI ON] ; Turn the AI on when
Type = VarSet
TriggerAll = Var(59) < 1; it is not on yet and
TriggerAll = RoundState=2 ; the fight has started and is not over yet and
Trigger1 = AILevel>0 ; the computer is playing the character
v = 59
value= 1 ; value of 1 will mean the AI is on
Ignorehitpause=1

[State -1, AI OFF] ; Turn the AI off when
Type=VarSet
Trigger1=var(59)>0 ; it is on and
Trigger1=RoundState!=2 ; the round is not started yet or is already over
Trigger2=!IsHelper ; OR if we are a player, but
Trigger2=AILevel=0 ; the computer is not in control
v=59
value=0 ; value of 0 will mean the AI is off. values other than 0 and 1 are not used in this example, we have only one AI mode, the normal one.
Ignorehitpause=1

[State -1]
Type=VarSet
Trigger1=1
var(50)= 10 ;Change the 60 to whatever you want. Take note of this value, as I mention it below.

[State -1]
Type=Changestate
Triggerall=Inguarddist; Guard when in guard distance
Triggerall=var(59)>0; and the AI is on
Triggerall=ctrl; and we have control
Trigger1 = random< (var(50)* 25) ; Feel free to change the * 99 to whatever you want, 
value=120

[State -1]; The engine will still guard by through pressing the back button, we need to disable that.
Type=Assertspecial
Triggerall=StateNo!=[120,160]
Trigger1=var(59)>0
flag=noairguard
flag2=nocrouchguard
flag3=nostandguard

;===========================================================================
;---------------------------------------------------------------------------

[State -1, Run] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
Triggerall = ctrl
triggerall = statetype = S
triggerall = statetype != A 
Triggerall = p2bodydist x  >= 5
trigger1 = random<var(50) * 25
value = 100


[State -1, Helper1] 
Type= Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
triggerall = statetype = S
triggerall = RoundState = 2
Triggerall = p2bodydist x  >= 70
Triggerall = Helper(9500), var(2) = 90
Trigger1 = ctrl
trigger1 = random<var(50) * 5
value = 4000

[State -1, Helper2] 
Type= Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
triggerall = statetype = S
triggerall = RoundState = 2
Triggerall = p2bodydist x  >= 70
Triggerall = Helper(9500), var(1) = 90
Trigger1 = ctrl
trigger1 = random<var(50) * 5
value = 4010

[State -1, Helper3] 
Type= Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
triggerall = statetype = S
triggerall = RoundState = 2
Triggerall = Helper(9500), var(3) = 90
Trigger1 = ctrl
trigger1 = random<var(50) * 5
value = 4020

[State -1, Attack1] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
Triggerall = ctrl
Triggerall = p2bodydist x <= 30
triggerall = statetype = S
trigger1 = random<var(50) * 25 
value = 200

[State -1, Attack2] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
Triggerall = ctrl
Triggerall = p2bodydist x <= 30
triggerall = statetype = S
trigger1 = random<var(50) * 5 
value = 210

[State -1, Attack3] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
Triggerall = ctrl
Triggerall = p2bodydist x <= 30
triggerall = statetype = S
trigger1 = random<var(50) * 2 
value = 220

[State -1, Attack4] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
Triggerall = ctrl
Triggerall = p2bodydist x <= 30
triggerall = statetype = S
trigger1 = random<var(50) * 25
value = 230

[State -1, Attack5] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
Triggerall = ctrl
Triggerall = p2bodydist x <= 30
triggerall = statetype = S
trigger1 = random<var(50) * 5
value = 240

[State -1, Attack6] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
Triggerall = ctrl
Triggerall = p2bodydist x <= 30
triggerall = statetype = S
trigger1 = random<var(50) * 2
value = 250

[State -1, Misil1] 
Type=Changestate
Triggerall = var(59)>0
triggerall = numproj = 0
Triggerall = alive = 1
Triggerall = ctrl
Triggerall = p2bodydist x  >= 50
triggerall = statetype = S
trigger1 = random<var(50) * 3
value = 1000

[State -1, Misil2] 
Type=Changestate
Triggerall = var(59)>0
triggerall = numproj = 0
Triggerall = alive = 1
Triggerall = ctrl
Triggerall = p2bodydist x  >= 50
triggerall = statetype = S
trigger1 = random<var(50) * 3
value = 1010

[State -1, Misil3] 
Type=Changestate
Triggerall = var(59)>0
triggerall = numproj = 0
Triggerall = alive = 1
Triggerall = ctrl
Triggerall = p2bodydist x  >= 50
triggerall = statetype = S
trigger1 = random<var(50) * 3
value = 1020

[State -1, Dash] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
Triggerall = ctrl
Triggerall = p2bodydist x  >= 30
triggerall = statetype = S
trigger1 = random<var(50) * 5
value = 2500

[State -1, GC] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
Triggerall = p2bodydist x  <= 15
triggerall = statetype = S
trigger1 = random<var(50) * 5
Trigger1 = ctrl
trigger2 = stateno = 2600 && movecontact 
trigger2 = p2statetype = A
trigger2 = time = 28
value = 2600

[State -1, Dash] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
Triggerall = ctrl
Triggerall = p2bodydist x  >= 30
triggerall = statetype = S
trigger1 = random<var(50) * 2
value = 2500


[State -1, SMisil] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
triggerall = power >= 1000
Triggerall = p2bodydist x  >= 50
triggerall = statetype = S
Trigger1 = ctrl
trigger1 = random <= 7
trigger2 = stateno = 3030 && movehit && animtime = 0
value = 3000


[State -1, SMisil2] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
triggerall = power >= 1000
Triggerall = p2bodydist x  >= 50
triggerall = statetype = S
trigger1 = random <= 5
Triggerall = ctrl
value = 3060

[State -1, FPunch] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
Triggerall = ctrl
triggerall = power >= 1000
Triggerall = p2bodydist x  = [70,200] 
triggerall = statetype = S
trigger1 = random <= 5
value = 3020

[State -1, SGlope] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
Triggerall = p2bodydist x <= 30
triggerall = statetype = S
triggerall = power >= 1000
trigger1 = random <= 7
Trigger1 = ctrl
trigger2 = stateno = 3030 && movehit && animtime = 0
value = 3010

[State -1, Beam] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
triggerall = power >= 2000
triggerall = statetype = S
trigger1 = random <= 7
Trigger1 = ctrl
trigger2 = stateno = 3000 && movehit && animtime = 0
value = 3030


[State -1, Clone] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
triggerall = power >= 2000
triggerall = statetype = S
Triggerall = ctrl
trigger1 = random <= 7
value = 3040


[State -1, SRain] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
triggerall = power >= 2000
Triggerall = p2bodydist x  >= 40
triggerall = statetype = S
Triggerall = ctrl
trigger1 = random <= 5
value = 3050

[State -1, RRC] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
triggerall = power >= 3000
triggerall = statetype = S
Triggerall = ctrl
trigger1 = random <= 300
value = 3070

[State -1, JUMP] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
triggerall = statetype = S
triggerall = statetype != A
triggerall = RoundState = 2
Triggerall = ctrl
Trigger1 = P2BodyDist X <= 50
trigger1 = random <= 10
Trigger2 = P2StateType = A
Trigger1 = P2BodyDist X <= 100
trigger2 = random <= 500 
value = 40

[State -1, Aattack] 
Type=Changestate
Triggerall = var(59)>0
Triggerall = alive = 1
triggerall = statetype = A
triggerall = RoundState = 2
Triggerall = ctrl
trigger1 = random<var(50) * 50
trigger2 = p2statetype = A 
value = 620






